package gov.va.med.mhv.bluebutton.web.controller;

import gov.va.med.mhv.bluebutton.transfer.BlueButtonReportDTO;
import gov.va.med.mhv.bluebutton.transfer.BlueButtonReportSelectionsDTO;
import gov.va.med.mhv.bluebutton.web.bean.BlueButtonFormBean;
import gov.va.med.mhv.bluebutton.web.bean.BlueButtonReportBean;
import gov.va.med.mhv.bluebutton.webservice.BlueButtonWebService;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.DateRangeEnum;
import gov.va.med.mhv.common.api.enumeration.InformationSelectionTypeEnum;
import gov.va.med.mhv.common.api.enumeration.UserTypeEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

@ManagedBean(name="downloadMyDataController")
@Component
@Scope("request")
public class DownloadMyDataController extends AbstractPhrController implements Serializable  {

	private static final String USER_ROLE_KEY = "LIFERAY_SHARED_accountType";
	private static Logger logger = LogManager.getLogger(DownloadMyDataController.class);
	private static final long serialVersionUID = 8393017856036882604L;
	
	@Value("${phrManagerendpointUrl}")
	private String phrManagerendpointUrl;

	@Autowired
	private BlueButtonReportBean reports;

	@Resource
	private BlueButtonWebService blueButtonWebserviceProxy;

	@Resource
	private UserMgmtService userMgmtServiceProxy;

	@Autowired
	private BlueButtonFormBean form;

	@Resource(name = "activityProxy")
	private AccountActivityCreatorService activityProxy;
	
	Boolean isBasicUser = null;
	Boolean isAdvancedUser = null;
	Boolean isPremiumUser = null;
	Boolean isChampVAUser = null;
	
	public void init(ComponentSystemEvent event) throws IOException {
		if(logger.isDebugEnabled()) {
			logger.debug("Initializing Refresh Status");
		}
		checkAndRefresh();
		form.initialize();
	}
	
	public BlueButtonFormBean getForm() {
		return form;
	}

	public void setForm(BlueButtonFormBean form) {
		this.form = form;
	}

	public String refreshStatus() {
		if(logger.isDebugEnabled()) {
			logger.debug("Checking Refresh Status");
		}
		checkAndRefresh();
		return "downloadMyData";
	}
	
	public String refreshStatusResults() {
		if(logger.isDebugEnabled()) {
			logger.debug("Checking Refresh Status");
		}
		checkAndRefresh();
		return "myDownloadResults";
	}

	public BlueButtonReportBean getReports() {
		return reports;
	}

	public void setReports(BlueButtonReportBean reports) {
		this.reports = reports;
	}

	/**
	 * {"fromDate":"Tue, 1 Aug 2015 14:58:09 GMT",
	 * "toDate":"Tue, 12 Jan 2016 14:58:09 GMT",
	 * "dataClasses":["vademographics","vachemlabs","vaallergies", "vaprogressnotes", "dodmilitaryservice"]}
	 *
	 * @return
	 */
	public String process() {
		if(logger.isDebugEnabled()) {
			logger.debug("Selections: " + form.getSelectedValues());
		}

		//Setup the request date for the UI
		reports.setRequestDate(new Date());
		findUser();
		SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
		BlueButtonReportSelectionsDTO selections = new BlueButtonReportSelectionsDTO();
		String typesOfInformation = form.getSelectForTypesOfInformation();
		if(typesOfInformation.equals("all")) {
			selections.setSelectionType(InformationSelectionTypeEnum.ALL_INFORMATION);
		} else {
			selections.setSelectionType(InformationSelectionTypeEnum.CUSTOM);
		}
		selections.setFromDate(sdf.format(form.getStartDate())); //"Tue, 1 Aug 2015 14:58:09 GMT
		selections.setToDate(sdf.format(form.getEndDate()));
		selections.setDataClasses(form.getSelectedValues().toArray(new String[]{}));
		if(selections.getDataClasses().length>0) {
			Calendar calendar = Calendar.getInstance();
			System.out.println("getDateSelection: " + form.getDateSelection());
			if(form.getDateSelection().equals("3")) {
				selections.setDateRange(DateRangeEnum.THREEMONTHS);
				form.setDateSelection("3");
				calendar.add(Calendar.MONTH, -3);
				selections.setFromDate(sdf.format(calendar.getTime()));
			} else if(form.getDateSelection().equals("6")) {
				selections.setDateRange(DateRangeEnum.SIXMONTHS);
				form.setDateSelection("6");
				calendar.add(Calendar.MONTH, -6);
				selections.setFromDate(sdf.format(calendar.getTime()));
			} else if(form.getDateSelection().equals("12")) {
				selections.setDateRange(DateRangeEnum.ONEYEAR);
				form.setDateSelection("12");
				calendar.add(Calendar.MONTH, -12);
				selections.setFromDate(sdf.format(calendar.getTime()));
			} else if(form.getDateSelection().equals("custom")) {
				selections.setDateRange(DateRangeEnum.CUSTOM);
				form.setDateSelection("custom");
			}
			//selections.setSelectionType(InformationSelectionTypeEnum.CUSTOM);
			try {
				System.out.println("Start Date Controller " + sdf.format(form.getStartDate()) + " End Date Controller " + sdf.format(form.getEndDate()));
				System.out.println("User Profile ID from Session " + getUserProfileIdFromSession());
				reports.setReport( blueButtonWebserviceProxy.generateReport(getUserProfileIdFromSession(), selections) );
			} catch (MHVException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
			User user=null;
	        try{
	        	user = PortalUtil.getUser(request);
	        }catch(Exception e){
	        	
	        }
			if(user != null){
				setFirstName(user.getFirstName());
				setLastName(user.getLastName());
				if(user.getMiddleName() != null) {
					setMiddleName(user.getMiddleName());
				} else {
					setMiddleName("");
				}
			}
			return "myDownloadResults?faces-redirect=true";
		} else {
			return "downloadMyData?faces-redirect=true";
		}
	}
	
	public String cancelButton() {
		return "selectReport";
	}
	
	public String cancelButtonTwo() {
		form.initialize();
		return "downloadMyData?faces-redirect=true";
	}
	
	public Boolean getIsBasicUser() throws MHVException {
		if (isBasicUser == null) {
			isBasicUser = new Boolean(UserTypeEnum.isBasic(getUserRoleFromSession()));
		}
		return isBasicUser;
	}

	public Boolean getIsAdvancedUser() throws MHVException {
		if (isAdvancedUser == null) {
			isAdvancedUser = new Boolean(UserTypeEnum.isAdvanced(getUserRoleFromSession()));
		}
		return isAdvancedUser;
	}

	public Boolean getIsPremiumUser() throws MHVException {
		if (isPremiumUser == null) {
			isPremiumUser = new Boolean(UserTypeEnum.isPremium(getUserRoleFromSession()));
		}
		return isPremiumUser;
	}

	public Boolean getIsChampVAUser() throws MHVException {
		UserProfileDTO userProfileDTO = getUserProfileDTOFromSession();
		if(userProfileDTO.getIsChampVABeneficiary() != null) {
			if(userProfileDTO.getIsChampVABeneficiary()) {
				isChampVAUser = true;
			} else {
				isChampVAUser = false;
			}
		} else {
			isChampVAUser = false;
		}
		return isChampVAUser;
	}
	
	protected UserTypeEnum getUserRoleFromSession() throws MHVException {
		UserTypeEnum userRole;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();

			String userRoleStr =  (String)session.getAttribute(USER_ROLE_KEY, PortletSession.APPLICATION_SCOPE);
			userRole = UserTypeEnum.valueOfByRole(userRoleStr);

		} catch(Exception e) {
			throw new MHVException("Unable to get user role from session");
		}
		return userRole;
	}
	
	public String getShowPdf() throws MHVException {
		long reportId = 0l;
		List<BlueButtonReportDTO> reportList = reports.getReportList();
		for(BlueButtonReportDTO bbReportDTO : reportList) {
			if(bbReportDTO.getType().equals("PDF")) {
				reportId = bbReportDTO.getReportId();
			}
		}
		activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(getUserProfileIdFromSession(), true, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.DOWNLOAD_MY_CUSTOM_DATA_PDF, ""));
		String showPdf = "/mhvapi/v1/bluebutton/external/stream/report/" + reportId + "/type/PDF";
		return showPdf;
	}
	
	public String getShowTxt() throws MHVException {
		long reportId = 0l;	
		List<BlueButtonReportDTO> reportList = reports.getReportList();
		for(BlueButtonReportDTO bbReportDTO : reportList) {
			if(bbReportDTO.getType().equals("TXT")) {
				reportId = bbReportDTO.getReportId();
			}
		}
		activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(getUserProfileIdFromSession(), true, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.DOWNLOAD_MY_CUSTOM_DATA, ""));
		String showTxt = "/mhvapi/v1/bluebutton/external/stream/report/" + reportId + "/type/TXT";
		return showTxt;
	}

}